/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import com.aptana.ide.ui.io.navigator.FileSystemObject;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class FileSystemPasteAction
extends BaseSelectionListenerAction {
    public static final String ID = "com.aptana.ui.io.PasteAction";
    private static final IFileStore[] NO_FILES = new IFileStore[0];
    private Shell fShell;
    private List<Object> selectedFiles;
    private Clipboard fClipboard;
    private IFileStore[] fClipboardData;
    private List<IFileStore> fDestFileStores;

    public FileSystemPasteAction(Shell shell, Clipboard clipboard) {
        super(Messages.FileSystemPasteAction_TXT);
        this.fShell = shell;
        this.fClipboard = clipboard;
        this.fDestFileStores = new ArrayList<IFileStore>();
        this.selectedFiles = new ArrayList<Object>();
        this.setToolTipText(Messages.FileSystemPasteAction_TTP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    public void run() {
        JobChangeAdapter jobAdapter = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                for (Object file : FileSystemPasteAction.this.selectedFiles) {
                    if (file instanceof IResource) {
                        try {
                            ((IResource)file).refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
                        }
                        continue;
                    }
                    IOUIPlugin.refreshNavigatorView(file);
                }
            }
        };
        if (this.fClipboardData != null && this.fClipboardData.length > 0 && this.fDestFileStores.size() > 0) {
            CopyFilesOperation operation = new CopyFilesOperation(this.fShell);
            operation.copyFiles((IAdaptable[])this.fClipboardData, this.fDestFileStores.get(0), (IJobChangeListener)jobAdapter);
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.fClipboard.getContents((Transfer)fileTransfer);
        if (fileData != null && fileData.length > 0 && this.fDestFileStores.size() > 0) {
            CopyFilesOperation operation = new CopyFilesOperation(this.fShell);
            operation.copyFiles(fileData, this.fDestFileStores.get(0), (IJobChangeListener)jobAdapter);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object[] elements;
        this.fDestFileStores.clear();
        this.selectedFiles.clear();
        this.fClipboardData = NO_FILES;
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = elements = selection.toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IFileStore fileStore = FileSystemPasteAction.getFileStore(element);
            if (fileStore != null) {
                if (!Utils.isDirectory((IAdaptable)fileStore)) {
                    fileStore = fileStore.getParent();
                }
                this.fDestFileStores.add(fileStore);
                if (element instanceof IAdaptable) {
                    IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                    if (resource != null) {
                        this.selectedFiles.add(resource instanceof IContainer ? resource : resource.getParent());
                    } else {
                        this.selectedFiles.add(new FileSystemObject(fileStore, FileSystemUtils.getFileInfo(fileStore)));
                    }
                }
            }
            ++n2;
        }
        if (this.fDestFileStores.size() == 0) {
            return false;
        }
        this.fShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                Object contents = FileSystemPasteAction.this.fClipboard.getContents((Transfer)transfer);
                if (contents instanceof StructuredSelection) {
                    Object[] elements = ((StructuredSelection)contents).toArray();
                    ArrayList<IFileStore> fileStores = new ArrayList<IFileStore>();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IFileStore) {
                            fileStores.add((IFileStore)element);
                        }
                        ++n2;
                    }
                    FileSystemPasteAction.this.fClipboardData = fileStores.toArray(new IFileStore[fileStores.size()]);
                }
            }
        });
        if (this.fClipboardData.length > 0) {
            return true;
        }
        TransferData[] transfers = this.fClipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i = 0;
        while (i < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IFileStore getFileStore(Object adaptable) {
        IResource resource;
        if (adaptable instanceof IAdaptable && (resource = (IResource)((IAdaptable)adaptable).getAdapter(IResource.class)) != null) {
            try {
                return EFS.getStore((URI)resource.getLocationURI());
            }
            catch (CoreException e) {
                return EFSUtils.getFileStore((IResource)resource);
            }
        }
        return FileSystemUtils.getFileStore(adaptable);
    }
}

